/*
 * I/O Routines for talking to the telnet-based switches. 
 */


#include <assert.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#ifndef _WIN32
#include <unistd.h>
#endif
#include <ctype.h>

#include "libfma.h"
#include "lf_switch_telnet.h"
#include "lf_internal.h"

/*
 * Open a stream connection to an enclosure
 */
FILE *
lf_telnet_open(
  char *host)
{
  char *s;
  int fd;
  FILE *fp;

  s = NULL;
  fd = -1;
  fp = NULL;

  /* open a connection to the host */
  fd = lf_connect_to_host (host, LF_SWITCH_TELNET_1_PORT);
  if (fd == -1) {
    return NULL;
  }
  fp = fdopen(fd, "r+");
  if (fp == NULL) {
    LF_ERROR(("Error from fdopen()"));
  }

  return fp;

 except:
  if (fp != NULL) {
    fclose(fp);
  } else if (fd != -1) {
    close(fd);
  }
  return NULL;
}

FILE *
lf_telnet_query(
  char *host,
  char *query)
{
#ifndef _DEBUG_SWITCH_
  FILE *fp;
  int size;

  fp = NULL;

  /* open a connection to the host */
  fp = lf_telnet_open(host);
  if (fp == NULL) {
    return NULL;
  }

  /* build the text of the request */
  size = strlen(query);

  /* write the request to the server */
  if (fwrite (query, 1, size, fp) != size) {
    LF_ERROR(("write failed"));
  }

  return fp;

 except:
  if (fp != NULL) {
    fclose(fp);
  }
  return NULL;

#else
  lf_string_t path;
  FILE *fp;

  fp = NULL;

  /* open a connection to the host */
  sprintf(path, "/tmp/switch/%s/%s", host, query);
  fp = fopen(path, "r");
  if (fp == NULL) {
    return NULL;
  }
  return fp;

 except:
  if (fp != NULL) {
    fclose(fp);
  }
  return NULL;
#endif
}

void
lf_telnet_close (FILE *fp)
{
  fclose (fp);
}

void
lf_telnet_end(
  FILE *fp)
{
  fprintf(fp, "bye\n");
  lf_telnet_close(fp);
}
